Scriptname _SLSubmitAutoSurrenderEffect extends activemagiceffect  

_SLSubmitQuest Property _SLQuest Auto
_SLSubmitFunctions Property _SLFunctions Auto
_SLSubmitConfig Property _SLConfig Auto
_SLSubmitScene Property _SLScene Auto
GlobalVariable Property _SLSubmitSurrenderGlobal  Auto
GlobalVariable Property _SLSubmitHardcoreBindings Auto
SPELL Property _SLSubmitAssign  Auto  
Race Property Werewolf Auto
Actor Property PlayerRef Auto
Race DLC1VampireBeast
Bool InBlackBook
Weapon Property Fists Auto


;==================================
;Events functions
;==================================
Event OnEffectStart(Actor akTarget, Actor akCaster)
	_SLScene.WRT(1.0)
	If (_SLConfig.NoDeathActive)
		PlayerRef.GetActorBase().SetProtected()
	EndIf
	Debug.Notification("Auto Surrender is Enabled!")
	If (_SLQuest.Dawnguard)
		DLC1VampireBeast = Game.GetFormFromFile(0x283A, "Dawnguard.esm") as Race
	EndIf
	If (_SLQuest.Dragonborn)
		_SLFunctions.InitializeBlackBooks()
		InBlackBook = _SLFunctions.IsInBook()
	Else
		InBlackBook = False
	EndIf
EndEvent
 
Event OnEffectFinish(Actor akTarget, Actor akCaster)
	_SLScene.WRT(1.0)
	PlayerRef.GetActorBase().SetProtected(False)
	Debug.Notification("Auto Surrender is Disabled!")
EndEvent

Event OnObjectEquipped(Form akBaseObject, ObjectReference akReference)
	If (akBaseObject.GetFormID() == 500)
		PlayerRef.GetActorBase().SetProtected(False)
		_SLQuest.Brawling = True
		If(_SLConfig.debugActive)
			Debug.Notification("Brawling!")
		EndIf
		RegisterForSingleUpdate(0.5)
	EndIf
EndEvent

Event OnUpdate()
	If (_SLQuest.Brawling)
		If (!PlayerRef.IsInCombat())
			_SLScene.WRT(5.0)
			PlayerRef.UnequipItemEx(Fists, 1)
			PlayerRef.GetActorBase().SetProtected()
			_SLQuest.Brawling = False
			If(_SLConfig.debugActive)
				Debug.Notification("Not Brawling!")
			EndIf
		Else
			RegisterForSingleUpdate(0.5)
		EndIf
	EndIf
EndEvent

Event OnEnterBleedout()	
	If (!InBlackBook && !_SLQuest.Brawling && _SLConfig.NoDeathActive && _SLConfig.modActive && PlayerRef.GetRace() != Werewolf && PlayerRef.GetRace() != DLC1VampireBeast)
		PlayerRef.GetActorBase().SetInvulnerable()
		Game.DisablePlayerControls()
		PlayerRef.ResetHealthAndLimbs()
		Debug.SendAnimationEvent(PlayerRef, "BleedOutStart")
		If !_SLFunctions.AutoSurrender()
			If(_SLConfig.debugActive)
				Debug.Notification("Your wounds are mortal...")
			EndIf
			KillPlayer()
		EndIf
		_SLScene.WRT(5.0)
		PlayerRef.GetActorBase().SetInvulnerable(False)
	ElseIf (PlayerRef.GetRace() == Werewolf || PlayerRef.GetRace() == DLC1VampireBeast)
		KillPlayer()
	EndIf
EndEvent

Event OnLocationChange(Location akOldLoc, Location akNewLoc)
	If _SLQuest.Dragonborn
		InBlackBook = _SLFunctions.IsInBook()
	EndIf
EndEvent

Function KillPlayer()
	PlayerRef.GetActorBase().SetProtected(False)
	PlayerRef.KillEssential()
EndFunction
